(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17825,        686]*)
(*NotebookOutlinePosition[     18727,        716]*)
(*  CellTagsIndexPosition[     18683,        712]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Picard's Method", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "     In the latter part of the nineteenth century, ",
  StyleBox["Charles \[CapitalEAcute]mile Picard",
    FontWeight->"Bold"],
  " gave an iterative method for producing a sequence of functions whose \
limit on a subinterval about x0 of [a, b] was a solution to the initial value \
problem\n\t\t",
  StyleBox["y'[x] == f[x, y[x]],  y[x0] == y0", "Input",
    FontWeight->"Bold"],
  StyleBox[".\n",
    FontWeight->"Bold"],
  "His technique was to perform repeated integrations of the differential \
equation:\t\t\n\t\t",
  Cell[BoxData[
      \(\(y[n + 1]\)[x_] = 
        y0 + \[Integral]\_x0\%x f[t, \(y[n]\)[t]] \[DifferentialD]t\)]],
  ", n \[GreaterEqual] 0\nstarting from the constant function ",
  StyleBox["y[0][x_]=y0", "Input",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Example 1 (Single Differential Equation)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Indicate the first 10 steps in the solution of ",
  StyleBox["y'==y-1, y[0]==2",
    FontWeight->"Bold"],
  " by Picard's method."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Define the function:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[y, Picard]\), "\n", 
    \(Picard[y_, x_] := 
      y0 + \[Integral]\_0\%x\((y[t] - 1)\) \[DifferentialD]t\)}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the initial value:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 = 2\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the starting (constant) function:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y[0]\)[x_] = y0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Iterate"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Now iterate as Picard's method suggests: (We print each iterant.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[\(y[n + 1]\)[x_] = Picard[y[n], x]; 
      Print[\(y[n + 1]\)[x]], {n, 0, 9}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2 + x\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120 + x\^6\/720\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120 + x\^6\/720 + 
      x\^7\/5040\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120 + x\^6\/720 + 
      x\^7\/5040 + x\^8\/40320\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120 + x\^6\/720 + 
      x\^7\/5040 + x\^8\/40320 + x\^9\/362880\)], "Print"],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120 + x\^6\/720 + 
      x\^7\/5040 + x\^8\/40320 + x\^9\/362880 + x\^10\/3628800\)], "Print"]
}, Closed]],

Cell[TextData[
"Let's look at the definition of the last iterant produced:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y[10]\)[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2 + x + x\^2\/2 + x\^3\/6 + x\^4\/24 + x\^5\/120 + x\^6\/720 + 
      x\^7\/5040 + x\^8\/40320 + x\^9\/362880 + x\^10\/3628800\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find a match"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"This looks a lot like the initial Taylor polynomial for a familiar function: \
"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[1 + Exp[x], {x, 0, 10}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "2", "+", "x", "+", \(x\^2\/2\), "+", \(x\^3\/6\), "+", \(x\^4\/24\), 
        "+", \(x\^5\/120\), "+", \(x\^6\/720\), "+", \(x\^7\/5040\), 
        "+", \(x\^8\/40320\), "+", \(x\^9\/362880\), "+", \(x\^10\/3628800\), 
        "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 0, 11, 1]]}],
      SeriesData[ x, 0, {2, 1, 
        Rational[ 1, 2], 
        Rational[ 1, 6], 
        Rational[ 1, 24], 
        Rational[ 1, 120], 
        Rational[ 1, 720], 
        Rational[ 1, 5040], 
        Rational[ 1, 40320], 
        Rational[ 1, 362880], 
        Rational[ 1, 3628800]}, 0, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Problem"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Show that y[x_]=1+Exp[x] is a (the) solution of the given problem."], "Text",\

  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2 (Single Differential Equation)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Indicate the first 5 steps in the solution of ",
  StyleBox["y'==y^2+1, y[0]==0",
    FontWeight->"Bold"],
  " by Picard's method."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Define the function:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[y, Picard]\), "\n", 
    \(Picard[y_, x_] := 
      y0 + \[Integral]\_0\%x\((y[t]\^2 + 1)\) \[DifferentialD]t\)}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the initial value:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 = 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the starting (constant) function:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y[0]\)[x_] = y0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Iterate"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Now iterate as Picard's method suggests: (We supress printing each iterant. \
To see why, remove the comment (* *) pairs.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Do[\(\(y[n + 1]\)[x_] = Picard[y[n], x];\), {n, 0, 5}]\)], "Input",
  AspectRatioFixed->False],

Cell[TextData[
"Let's look at the definition of the last iterant produced:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[\(y[6]\)[x], 7]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x + 
      x\^3\/3 + \(2\ x\^5\)\/15 + \(17\ x\^7\)\/315 + \(62\ x\^9\)\/2835 + \
\(1382\ x\^11\)\/155925 + \(20404\ x\^13\)\/6081075\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find a match"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"This looks a lot like the initial Taylor polynomial for a familiar function: \
"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[Tan[x], {x, 0, 13}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "x", "+", \(x\^3\/3\), "+", \(\(2\ x\^5\)\/15\), 
        "+", \(\(17\ x\^7\)\/315\), "+", \(\(62\ x\^9\)\/2835\), 
        "+", \(\(1382\ x\^11\)\/155925\), "+", \(\(21844\ x\^13\)\/6081075\), 
        "+", 
        InterpretationBox[\(O[x]\^14\),
          SeriesData[ x, 0, {}, 1, 14, 1]]}],
      SeriesData[ x, 0, {1, 0, 
        Rational[ 1, 3], 0, 
        Rational[ 2, 15], 0, 
        Rational[ 17, 315], 0, 
        Rational[ 62, 2835], 0, 
        Rational[ 1382, 155925], 0, 
        Rational[ 21844, 6081075]}, 1, 14, 1]]], "Output"]
}, Closed]],

Cell[TextData[
"Note that the Piccard iterant is not quite correct in the coefficient of \
x^13.  It would appear that each iteration gives essentially one extra \
correct term."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Problem"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Show that y[x_]=Tan[x] is a (the) solution of the given problem."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Comment"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"It is clear that the manipulations can gradually become immense.  One really \
only does this iteration for a few steps.  Numerically, other techniques are \
much better.  But this does show that something is happening, and if one were \
to plot the successive approximations on the same set of axes, it would be \
clear that some form of convergence is taking place."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Problems"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Start each of the previous iterations off at some constant which is \
different from y0.  Also try starting the iteration off with y[0][x] being \
some polynomial of reasonably small degree. How do the results which we just \
observed differ in these cases.  How might this modify the statement of \
Picard's method which was given in the introductory paragraph?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 3 (System of Differential Equations)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Consider the system of differential equations from example 9.7 of the \
text:\n\t\t",
  StyleBox["y'[x]==-z[x]\n\t\t z'[x]==y[x]", "Input"],
  "\nstarting at the point ",
  StyleBox["{y[0], z[0]}=={1, 0}", "Input"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Define the function:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[y, Picard]\), "\n", 
    \(Picard[y_, z_, 
        x_] := {y0, 
          z0} + \[Integral]\_0\%x{\(-z[t]\), 
              y[t]} \[DifferentialD]t\)}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the initial value:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({y0, z0} = {1, 0}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the starting (constant) function:"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({\(y[0]\)[x_], \(z[0]\)[x_]} = {y0, z0}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Iterate"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Now iterate as Picard's method suggests: (We print each iterant.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[{\(y[n + 1]\)[x_], \(z[n + 1]\)[x_]} = Picard[y[n], z[n], x]; 
      Print[{\(y[n + 1]\)[x], \(z[n + 1]\)[x]}], {n, 0, 9}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, x}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2, x}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2, x - x\^3\/6}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24, x - x\^3\/6}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24, x - x\^3\/6 + x\^5\/120}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24 - x\^6\/720, 
      x - x\^3\/6 + x\^5\/120}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24 - x\^6\/720, 
      x - x\^3\/6 + x\^5\/120 - x\^7\/5040}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24 - x\^6\/720 + x\^8\/40320, 
      x - x\^3\/6 + x\^5\/120 - x\^7\/5040}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24 - x\^6\/720 + x\^8\/40320, 
      x - x\^3\/6 + x\^5\/120 - x\^7\/5040 + x\^9\/362880}\)], "Print"],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24 - x\^6\/720 + x\^8\/40320 - x\^10\/3628800, 
      x - x\^3\/6 + x\^5\/120 - x\^7\/5040 + x\^9\/362880}\)], "Print"]
}, Closed]],

Cell[TextData[
"Let's look at the definition of the last pair of iterants produced:"], "Text",\

  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({\(y[10]\)[x], \(z[10]\)[x]}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1 - x\^2\/2 + x\^4\/24 - x\^6\/720 + x\^8\/40320 - x\^10\/3628800, 
      x - x\^3\/6 + x\^5\/120 - x\^7\/5040 + x\^9\/362880}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find a match"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({Series[Cos[x], {x, 0, 10}], Series[Sin[x], {x, 0, 10}]}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{
          "1", "-", \(x\^2\/2\), "+", \(x\^4\/24\), "-", \(x\^6\/720\), 
            "+", \(x\^8\/40320\), "-", \(x\^10\/3628800\), "+", 
            InterpretationBox[\(O[x]\^11\),
              SeriesData[ x, 0, {}, 0, 11, 1]]}],
          SeriesData[ x, 0, {1, 0, 
            Rational[ -1, 2], 0, 
            Rational[ 1, 24], 0, 
            Rational[ -1, 720], 0, 
            Rational[ 1, 40320], 0, 
            Rational[ -1, 3628800]}, 0, 11, 1]], ",", 
        InterpretationBox[
          RowBox[{
          "x", "-", \(x\^3\/6\), "+", \(x\^5\/120\), "-", \(x\^7\/5040\), 
            "+", \(x\^9\/362880\), "+", 
            InterpretationBox[\(O[x]\^11\),
              SeriesData[ x, 0, {}, 1, 11, 1]]}],
          SeriesData[ x, 0, {1, 0, 
            Rational[ -1, 6], 0, 
            Rational[ 1, 120], 0, 
            Rational[ -1, 5040], 0, 
            Rational[ 1, 362880]}, 1, 11, 1]]}], "}"}]], "Output"]
}, Closed]],

Cell["\<\
We successfully identified the pair {Cos[x],Sin[x]} as a likely \
solution. All that remains is to check.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(L[x_, y_, z_]\), "=", 
      RowBox[{"{", 
        StyleBox[\(\(y'\)[x] == \(-z[x]\), \(z'\)[x] == y[x]\),
          "Input"], 
        StyleBox["}",
          "Input"]}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "==", \(-z[x]\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["z", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "==", \(y[x]\)}]}], 
      "}"}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, Cos, Sin]\)], "Input"],

Cell[BoxData[
    \({True, True}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({Cos[0], Sin[0]}\)], "Input"],

Cell[BoxData[
    \({1, 0}\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{545, 542},
WindowMargins->{{4, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 83, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1862, 57, 850, 22, 142, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2737, 83, 118, 2, 56, "Section",
  Evaluatable->False],
Cell[2858, 87, 210, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3093, 98, 104, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[3200, 102, 174, 4, 60, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3411, 111, 109, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3545, 117, 66, 2, 27, "Input"],
Cell[3614, 121, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3698, 128, 124, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3847, 134, 77, 2, 27, "Input"],
Cell[3927, 138, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4011, 145, 91, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[4105, 149, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4271, 156, 140, 3, 43, "Input"],
Cell[4414, 161, 38, 1, 23, "Print"],
Cell[4455, 164, 48, 1, 41, "Print"],
Cell[4506, 167, 58, 1, 41, "Print"],
Cell[4567, 170, 69, 1, 41, "Print"],
Cell[4639, 173, 81, 1, 41, "Print"],
Cell[4723, 176, 93, 1, 41, "Print"],
Cell[4819, 179, 113, 2, 41, "Print"],
Cell[4935, 183, 127, 2, 41, "Print"],
Cell[5065, 187, 142, 2, 41, "Print"],
Cell[5210, 191, 159, 2, 41, "Print"]
}, Closed]],
Cell[5384, 196, 134, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5543, 203, 72, 2, 27, "Input"],
Cell[5618, 207, 160, 2, 82, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5827, 215, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[5926, 219, 155, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6106, 227, 90, 2, 27, "Input"],
Cell[6199, 231, 689, 18, 82, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6937, 255, 88, 2, 46, "Subsection",
  Evaluatable->False],
Cell[7028, 259, 144, 4, 70, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7221, 269, 118, 2, 36, "Section",
  Evaluatable->False],
Cell[7342, 273, 211, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7578, 284, 104, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[7685, 288, 177, 4, 60, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[7899, 297, 109, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8033, 303, 66, 2, 27, "Input"],
Cell[8102, 307, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8186, 314, 124, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8335, 320, 77, 2, 27, "Input"],
Cell[8415, 324, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8499, 331, 91, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[8593, 335, 198, 4, 50, "Text",
  Evaluatable->False],
Cell[8794, 341, 114, 2, 27, "Input"],
Cell[8911, 345, 134, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9070, 352, 80, 2, 27, "Input"],
Cell[9153, 356, 167, 3, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9369, 365, 96, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[9468, 369, 155, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9648, 377, 86, 2, 27, "Input"],
Cell[9737, 381, 604, 15, 45, "Output"]
}, Closed]],
Cell[10356, 399, 237, 5, 50, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10630, 409, 88, 2, 46, "Subsection",
  Evaluatable->False],
Cell[10721, 413, 140, 3, 70, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10910, 422, 85, 2, 36, "Section",
  Evaluatable->False],
Cell[10998, 426, 443, 7, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[11478, 438, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[11567, 442, 438, 7, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[12042, 454, 122, 2, 36, "Section",
  Evaluatable->False],
Cell[12167, 458, 301, 9, 85, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12493, 471, 104, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[12600, 475, 215, 6, 60, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12852, 486, 109, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12986, 492, 77, 2, 27, "Input"],
Cell[13066, 496, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13155, 503, 124, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13304, 509, 99, 2, 27, "Input"],
Cell[13406, 513, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13495, 520, 91, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[13589, 524, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13755, 531, 185, 3, 43, "Input"],
Cell[13943, 536, 39, 1, 23, "Print"],
Cell[13985, 539, 49, 1, 41, "Print"],
Cell[14037, 542, 59, 1, 41, "Print"],
Cell[14099, 545, 70, 1, 41, "Print"],
Cell[14172, 548, 82, 1, 41, "Print"],
Cell[14257, 551, 101, 2, 41, "Print"],
Cell[14361, 555, 114, 2, 41, "Print"],
Cell[14478, 559, 128, 2, 41, "Print"],
Cell[14609, 563, 143, 2, 41, "Print"],
Cell[14755, 567, 160, 2, 78, "Print"]
}, Closed]],
Cell[14930, 572, 145, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15100, 580, 88, 2, 27, "Input"],
Cell[15191, 584, 161, 2, 82, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15401, 592, 96, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15522, 598, 116, 2, 27, "Input"],
Cell[15641, 602, 1021, 25, 82, "Output"]
}, Closed]],
Cell[16677, 630, 129, 3, 32, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[16843, 638, 30, 0, 42, "Subsubsection"],

Cell[CellGroupData[{
Cell[16898, 642, 211, 6, 27, "Input"],
Cell[17112, 650, 399, 12, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17548, 667, 47, 1, 27, "Input"],
Cell[17598, 670, 46, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17681, 676, 49, 1, 27, "Input"],
Cell[17733, 679, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

